# Telegram Broadcast Bot

Complete PHP system for broadcasting messages to multiple Telegram groups.

## Quick Setup

1. **Database:** Already configured (tashanw3_selimxpro)
2. **Bot Token:** Already configured
3. **Create Table:** Run `sql/database_schema.sql` in phpMyAdmin
4. **Set Webhook:** Visit `setup_webhook.php`
5. **Access Admin:** `admin/login.php` (admin/admin123)

## Features

- ✅ Send to specific group by link/ID
- ✅ Broadcast to all groups
- ✅ Delete groups
- ✅ Refresh groups list
- ✅ Auto group registration
- ✅ **Auto Messages** - Schedule messages to be sent automatically (daily/weekly)

## Admin Panel Options

1. **Send to Specific Group** - Enter group link/ID and message
2. **Broadcast to All** - Send message to all registered groups
3. **Auto Messages** - Schedule automatic messages (daily/weekly at specific times)
4. **Refresh Groups** - Reload groups list
5. **Delete Group** - Remove individual groups
6. **Delete All** - Clear all groups

## Auto Messages Setup

### Features:
- ⏰ Schedule messages at specific times
- 📅 Daily or Weekly frequency
- ⏱️ **Interval Messages** - Send multiple messages in a time range (e.g., every minute from 3 PM to 4 PM)
- ➕ Add multiple scheduled messages
- ✏️ Edit, delete, enable/disable messages
- 🔄 Automatic sending via cron job

### Interval Messages:
- Set a start time and end time (e.g., 15:00 to 16:00)
- Set interval in minutes (e.g., 1 = every minute, 5 = every 5 minutes)
- Messages will be sent automatically at the specified interval within the time range
- Perfect for sending multiple different messages during a specific time period

### Setup Cron Job:

#### Windows (Task Scheduler):

**Automatic Setup (Recommended):**
1. PowerShell ko **Administrator mode** mein kholo
2. Project folder mein jao: `cd C:\Users\mdasi\OneDrive\Desktop\botcom`
3. Setup script run karo:
   ```powershell
   .\cron\setup_windows_task.ps1
   ```
   Ya double-click karo: `cron\setup_windows_task.bat`

**Manual Setup:**
1. Task Scheduler kholo (`taskschd.msc`)
2. "Create Basic Task" click karo
3. Name: `TelegramBotAutoMessages`
4. Trigger: Daily → Start time: abhi ka time
5. Action: Start a program
   - Program: `C:\php\php.exe` (ya apna PHP path)
   - Arguments: `"C:\Users\mdasi\OneDrive\Desktop\botcom\cron\send_auto_messages.php"`
   - Start in: `C:\Users\mdasi\OneDrive\Desktop\botcom`
6. Task properties mein jao → Triggers → Edit
   - "Repeat task every" check karo → 1 minute
   - Duration: Indefinitely

**Task ko check karne ke liye:**
```powershell
Get-ScheduledTask -TaskName "TelegramBotAutoMessages"
Start-ScheduledTask -TaskName "TelegramBotAutoMessages"  # Manual run
```

#### Linux/Unix (Crontab):

To enable automatic message sending, set up a cron job that runs every minute:

```bash
* * * * * php /path/to/your/project/cron/send_auto_messages.php
```

Or using curl (if accessible via web):
```bash
* * * * * curl -s https://yourdomain.com/cron/send_auto_messages.php > /dev/null
```

**Crontab edit karne ke liye:**
```bash
crontab -e
```

### Testing:

You can manually test the auto messages by accessing:
- `cron/test_cron.php` (via browser - shows what messages will be sent)
- `cron/test_auto_messages.php` (via browser - add security restrictions in production)

**Command line se test:**
```bash
php cron/send_auto_messages.php
```

## Files

- `config/config.php` - All configuration
- `admin/dashboard.php` - Main admin panel
- `admin/auto_messages.php` - Auto messages management
- `webhook/bot.php` - Telegram webhook handler
- `cron/send_auto_messages.php` - Cron job for sending scheduled messages
- `sql/database_schema.sql` - Database tables

Done! 🚀
