<?php
/**
 * Authentication Helper Functions
 * Session-based authentication with hardcoded credentials (for demo)
 */

/**
 * Check if user is logged in
 * Redirects to login.php if not authenticated
 */
function requireAuth() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    // Check if session is valid
    if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        // Store the requested URL for redirect after login
        $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
        
        // Redirect to login
        header('Location: login.php');
        exit;
    }
    
    // Regenerate session ID periodically for security
    if (!isset($_SESSION['last_regeneration']) || 
        (time() - $_SESSION['last_regeneration']) > 300) { // Every 5 minutes
        session_regenerate_id(true);
        $_SESSION['last_regeneration'] = time();
    }
}

/**
 * Check if user is logged in (returns boolean, doesn't redirect)
 * Useful for API endpoints
 */
function isAuthenticated() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

/**
 * Verify login credentials
 * Uses hardcoded credentials from config (for demo)
 */
function verifyCredentials($username, $password) {
    require_once __DIR__ . '/../config/config.php';
    
    return ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD);
}

/**
 * Login user and create session
 */
function login($username) {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    $_SESSION['admin_logged_in'] = true;
    $_SESSION['admin_username'] = $username;
    $_SESSION['login_time'] = time();
    $_SESSION['last_regeneration'] = time();
    
    // Regenerate session ID on login for security
    session_regenerate_id(true);
}

/**
 * Logout user and destroy session
 */
function logout() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    $_SESSION = [];
    
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    
    session_destroy();
}
