<?php
/**
 * Auto Messages Admin Panel - Simplified
 * Sirf 1 minute interval ke liye - Color Prediction Game ke saath
 */

require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/color_prediction.php';

// Require authentication
requireAuth();

// Initialize database
$db = Database::getInstance();
$db->initDatabase();

// Get all groups
$allGroups = $db->getAllGroups();

// Handle form submissions
$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'toggle_color_prediction') {
        // Toggle color prediction on/off
        $isEnabled = isset($_POST['enabled']) && $_POST['enabled'] === '1';
        
        // Check if color prediction message exists
        $allMessages = $db->getAllAutoMessages();
        $colorPredictionMsg = null;
        
        foreach ($allMessages as $msg) {
            if (strpos($msg['message'], 'COLOR PREDICTION') !== false) {
                $colorPredictionMsg = $msg;
                break;
            }
        }
        
        if ($isEnabled) {
            // Enable color prediction - create message if doesn't exist
            if (!$colorPredictionMsg) {
                // Get selected groups
                $selectedGroups = $_POST['groups'] ?? [];
                $groupIds = !empty($selectedGroups) ? $selectedGroups : null;
                
                // Create a dummy message (actual message will be generated by cron)
                $dummyMsg = "🎯 COLOR PREDICTION GAME - Auto Enabled";
                $currentTime = date('H:i');
                $endTime = '23:59';
                
                $db->addAutoMessage(
                    $dummyMsg, 
                    null, 
                    'interval', 
                    $currentTime, 
                    $endTime, 
                    1, // 1 minute interval
                    null, 
                    date('Y-m-d'), 
                    null, 
                    $groupIds
                );
                $message = 'Color Prediction Game enabled! Har 1 minute pe results groups mein jayenge.';
                $messageType = 'success';
            } else {
                // Enable existing message
                $db->toggleAutoMessage($colorPredictionMsg['id'], 1);
                $message = 'Color Prediction Game enabled!';
                $messageType = 'success';
            }
        } else {
            // Disable color prediction
            if ($colorPredictionMsg) {
                $db->toggleAutoMessage($colorPredictionMsg['id'], 0);
                $message = 'Color Prediction Game disabled!';
                $messageType = 'success';
            }
        }
    }
}

// Get all auto messages
$autoMessages = $db->getAllAutoMessages();

// Check if color prediction is enabled
$colorPredictionEnabled = false;
$colorPredictionMsg = null;
foreach ($autoMessages as $msg) {
    if (strpos($msg['message'], 'COLOR PREDICTION') !== false) {
        $colorPredictionEnabled = $msg['is_active'] == 1;
        $colorPredictionMsg = $msg;
        break;
    }
}

// Get selected groups for color prediction
$selectedGroupIds = [];
if ($colorPredictionMsg && !empty($colorPredictionMsg['group_ids'])) {
    $selectedGroupIds = json_decode($colorPredictionMsg['group_ids'], true);
    if (!is_array($selectedGroupIds)) {
        $selectedGroupIds = [];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Color Prediction Game - Admin Panel</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 14px;
        }
        
        .nav-buttons {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-top: 20px;
        }
        
        .btn {
            background: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.3);
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            font-size: 14px;
            transition: background 0.3s;
            cursor: pointer;
        }
        
        .btn:hover {
            background: rgba(255,255,255,0.3);
        }
        
        .content {
            padding: 30px;
        }
        
        .message {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 25px;
            font-size: 15px;
            font-weight: 500;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
            border-left: 4px solid #28a745;
        }
        
        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
            border-left: 4px solid #dc3545;
        }
        
        .game-section {
            background: #f8f9fa;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
            border: 2px solid #667eea;
        }
        
        .game-section h2 {
            color: #333;
            margin-bottom: 20px;
            font-size: 24px;
        }
        
        .status {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 600;
            margin-bottom: 20px;
        }
        
        .status.enabled {
            background: #28a745;
            color: white;
        }
        
        .status.disabled {
            background: #dc3545;
            color: white;
        }
        
        .info-box {
            background: #e7f3ff;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #0066cc;
        }
        
        .info-box h3 {
            color: #333;
            margin-bottom: 10px;
        }
        
        .info-box ul {
            color: #666;
            line-height: 1.8;
            padding-left: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }
        
        .group-selection {
            max-height: 300px;
            overflow-y: auto;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            padding: 15px;
            background: white;
        }
        
        .group-item {
            display: flex;
            align-items: center;
            padding: 8px;
            margin-bottom: 5px;
        }
        
        .group-item input[type="checkbox"] {
            margin-right: 10px;
            width: 18px;
            height: 18px;
            cursor: pointer;
        }
        
        .group-item label {
            cursor: pointer;
            margin: 0;
            font-weight: normal;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 14px 30px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
            width: 100%;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }
        
        .btn-danger {
            background: #dc3545;
            color: white;
            border: none;
            padding: 14px 30px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
        }
        
        .btn-danger:hover {
            background: #c82333;
        }
        
        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
            margin-left: 15px;
        }
        
        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }
        
        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: .4s;
            border-radius: 34px;
        }
        
        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }
        
        input:checked + .slider {
            background-color: #28a745;
        }
        
        input:checked + .slider:before {
            transform: translateX(26px);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎯 Color Prediction Game</h1>
            <p>Har 1 minute pe Big/Small/Number automatically groups mein bhejta hai</p>
            <div class="nav-buttons">
                <a href="dashboard.php" class="btn">📊 Dashboard</a>
                <a href="logout.php" class="btn">Logout</a>
            </div>
        </div>
        
        <div class="content">
            <?php if ($message): ?>
                <div class="message <?php echo $messageType; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>
            
            <div class="game-section">
                <h2>🎮 Game Status</h2>
                <div>
                    <span class="status <?php echo $colorPredictionEnabled ? 'enabled' : 'disabled'; ?>">
                        <?php echo $colorPredictionEnabled ? '✅ ENABLED' : '❌ DISABLED'; ?>
                    </span>
                </div>
                
                <div class="info-box">
                    <h3>ℹ️ How It Works:</h3>
                    <ul>
                        <li><strong>Big:</strong> Numbers 5-9 (🔴 Red)</li>
                        <li><strong>Small:</strong> Numbers 0-4 (🟢 Green)</li>
                        <li><strong>Number:</strong> Random 0-9 (🔵 Blue)</li>
                        <li><strong>Frequency:</strong> Har 1 minute pe automatically results groups mein jayenge</li>
                        <li><strong>Start:</strong> Enable karte hi turant start ho jayega</li>
                    </ul>
                </div>
                
                <form method="POST" id="gameForm">
                    <input type="hidden" name="action" value="toggle_color_prediction">
                    <input type="hidden" name="enabled" value="<?php echo $colorPredictionEnabled ? '0' : '1'; ?>" id="enabledInput">
                    
                    <div class="form-group">
                        <label>Select Groups (Leave empty to send to all groups):</label>
                        <div class="group-selection">
                            <?php if (empty($allGroups)): ?>
                                <p style="color: #999; font-size: 13px; margin: 0;">No groups registered yet. Add bot to groups first.</p>
                            <?php else: ?>
                                <div style="margin-bottom: 10px;">
                                    <input type="checkbox" id="selectAllGroups" onchange="toggleAllGroups(this)">
                                    <label for="selectAllGroups" style="display: inline; font-weight: 600; cursor: pointer;">Select All Groups</label>
                                </div>
                                <?php foreach ($allGroups as $group): ?>
                                    <div class="group-item">
                                        <input 
                                            type="checkbox" 
                                            name="groups[]" 
                                            id="group_<?php echo $group['id']; ?>" 
                                            value="<?php echo htmlspecialchars($group['group_id']); ?>"
                                            <?php echo (in_array($group['group_id'], $selectedGroupIds)) ? 'checked' : ''; ?>
                                            class="group-checkbox"
                                        >
                                        <label for="group_<?php echo $group['id']; ?>" style="margin: 0;">
                                            <?php echo htmlspecialchars($group['group_id']); ?>
                                        </label>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        <small style="color: #666; font-size: 12px; display: block; margin-top: 5px;">
                            💡 Select specific groups to receive color prediction results. If none selected, results will be sent to all groups.
                        </small>
                    </div>
                    
                    <?php if ($colorPredictionEnabled): ?>
                        <button type="submit" class="btn-danger">
                            ⏸️ Disable Color Prediction Game
                        </button>
                    <?php else: ?>
                        <button type="submit" class="btn-primary">
                            ▶️ Enable Color Prediction Game
                        </button>
                    <?php endif; ?>
                </form>
            </div>
            
            <div class="info-box">
                <h3>📝 Important Notes:</h3>
                <ul>
                    <li>Cron job har 1 minute pe run hoga (already setup hai)</li>
                    <li>Enable karte hi turant start ho jayega</li>
                    <li>Har minute pe ek naya result generate hoga aur groups mein jayega</li>
                    <li>Results automatically Big, Small, aur Number mein rotate honge</li>
                    <li>Task Scheduler check karein: <code>Get-ScheduledTask -TaskName "TelegramBotAutoMessages"</code></li>
                </ul>
            </div>
        </div>
    </div>
    
    <script>
        function toggleAllGroups(selectAll) {
            const checkboxes = document.querySelectorAll('.group-checkbox');
            checkboxes.forEach(function(checkbox) {
                checkbox.checked = selectAll.checked;
            });
        }
        
        // Auto-hide success messages after 5 seconds
        setTimeout(function() {
            const successMsg = document.querySelector('.message.success');
            if (successMsg) {
                successMsg.style.display = 'none';
            }
        }, 5000);
    </script>
</body>
</html>
