<?php
/**
 * Delete All Groups Handler
 */

require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $db = Database::getInstance();
    $db->initDatabase();
    
    $db->deleteAllGroups();
    
    echo json_encode(['success' => true, 'message' => 'All groups deleted successfully']);
} catch (Exception $e) {
    error_log("Delete all groups error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Internal server error']);
}
