<?php
/**
 * Delete Group Handler
 */

require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$groupId = trim($_POST['group_id'] ?? '');

if (empty($groupId)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Group ID is required']);
    exit;
}

try {
    $db = Database::getInstance();
    $db->initDatabase();
    
    $deleted = $db->deleteGroup($groupId);
    
    if ($deleted) {
        echo json_encode(['success' => true, 'message' => 'Group deleted successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Group not found']);
    }
} catch (Exception $e) {
    error_log("Delete group error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Internal server error']);
}
