<?php
/**
 * Color Prediction Game Logic
 * Generates Big/Small/Number results for color prediction game
 */

class ColorPredictionGame {
    
    /**
     * Generate random result for color prediction
     * 
     * @param string $type 'big', 'small', or 'number'
     * @return string Result value
     */
    public static function generateResult($type) {
        switch ($type) {
            case 'big':
                // Big: 5-9
                return (string)rand(5, 9);
                
            case 'small':
                // Small: 0-4
                return (string)rand(0, 4);
                
            case 'number':
                // Number: 0-9
                return (string)rand(0, 9);
                
            default:
                return (string)rand(0, 9);
        }
    }
    
    /**
     * Format message for color prediction result
     * 
     * @param string $type Result type
     * @param string $value Result value
     * @param int $period Period number
     * @return string Formatted message
     */
    public static function formatMessage($type, $value, $period) {
        $emoji = '';
        $typeText = '';
        
        switch ($type) {
            case 'big':
                $emoji = '🔴';
                $typeText = 'BIG';
                break;
            case 'small':
                $emoji = '🟢';
                $typeText = 'SMALL';
                break;
            case 'number':
                $emoji = '🔵';
                $typeText = 'NUMBER';
                break;
        }
        
        $message = "🎯 <b>COLOR PREDICTION RESULT</b>\n\n";
        $message .= "{$emoji} <b>Type:</b> {$typeText}\n";
        $message .= "🎲 <b>Result:</b> {$value}\n";
        $message .= "⏰ <b>Period:</b> #{$period}\n\n";
        $message .= "💰 <b>Win Big!</b> 💰";
        
        return $message;
    }
    
    /**
     * Generate all three types (big, small, number) for current period
     * 
     * @return array Array of results
     */
    public static function generateAllResults() {
        return [
            'big' => self::generateResult('big'),
            'small' => self::generateResult('small'),
            'number' => self::generateResult('number')
        ];
    }
}
