# Telegram Bot - Cron Job Setup Guide (Hindi/English)

## Cron Job Setup - Har 1 Minute Pe Messages Automatically Groups Mein Bhejne Ke Liye

### Windows Setup (Recommended)

#### Method 1: Automatic Setup (Sabse Aasan)

1. **PowerShell ko Administrator mode mein kholo:**
   - Start menu mein "PowerShell" search karo
   - Right-click karo → "Run as Administrator"

2. **Project folder mein jao:**
   ```powershell
   cd "C:\Users\mdasi\OneDrive\Desktop\botcom"
   ```

3. **Setup script run karo:**
   ```powershell
   .\cron\setup_windows_task.ps1
   ```
   
   Ya simple double-click karo: `cron\setup_windows_task.bat`

4. **Script automatically:**
   - PHP check karega
   - Task Scheduler mein task create karega
   - Har 1 minute pe automatically run hoga

#### Method 2: Manual Setup

1. **Task Scheduler kholo:**
   - Windows + R press karo
   - Type: `taskschd.msc`
   - Enter press karo

2. **Create Basic Task:**
   - Right side pe "Create Basic Task" click karo
   - Name: `TelegramBotAutoMessages`
   - Description: `Har 1 minute pe Telegram groups mein messages bhejta hai`
   - Next click karo

3. **Trigger Setup:**
   - Trigger: Daily select karo
   - Start time: Abhi ka time (kuch bhi, baad mein change hoga)
   - Next click karo

4. **Action Setup:**
   - Action: "Start a program" select karo
   - Program/script: PHP ka path (e.g., `C:\php\php.exe`)
     - PHP path find karne ke liye: `where php` command PowerShell mein run karo
   - Add arguments: `"C:\Users\mdasi\OneDrive\Desktop\botcom\cron\send_auto_messages.php"`
   - Start in: `C:\Users\mdasi\OneDrive\Desktop\botcom`
   - Next click karo

5. **Task Properties Edit:**
   - "Open the Properties dialog" checkbox check karo
   - Finish click karo
   - Properties window mein "Triggers" tab pe jao
   - Trigger select karo → Edit click karo
   - "Repeat task every" checkbox check karo
   - Duration: 1 minute select karo
   - "for a duration of" → Indefinitely select karo
   - OK click karo

6. **Settings Tab:**
   - "Allow task to be run on demand" check karo
   - "Run task as soon as possible after a scheduled start is missed" check karo
   - "If the task fails, restart every" → 1 minute
   - OK click karo

### Linux/Unix Setup

**Crontab edit karo:**
```bash
crontab -e
```

**Ye line add karo (har 1 minute pe run hoga):**
```bash
* * * * * php /path/to/your/project/cron/send_auto_messages.php
```

**Ya curl se (agar web accessible hai):**
```bash
* * * * * curl -s https://yourdomain.com/cron/send_auto_messages.php > /dev/null
```

### Testing

#### Browser Se Test:
1. Browser mein kholo: `http://yourdomain.com/cron/test_cron.php`
2. Ye dikhayega ki kaun se messages send honge
3. "Send Messages Now" button se manually send kar sakte ho

#### Command Line Se Test:
```bash
php cron/send_auto_messages.php
```

#### Windows Task Check:
```powershell
# Task status check
Get-ScheduledTask -TaskName "TelegramBotAutoMessages"

# Task manually run karo
Start-ScheduledTask -TaskName "TelegramBotAutoMessages"

# Task history dekhne ke liye
Get-WinEvent -LogName Microsoft-Windows-TaskScheduler/Operational | Where-Object {$_.Message -like "*TelegramBotAutoMessages*"} | Select-Object -First 10
```

### Troubleshooting

**Problem: PHP nahi mil raha**
- Solution: PHP install karo ya PATH mein add karo
- Check: `php -v` command se verify karo

**Problem: Task run nahi ho raha**
- Solution: Task Scheduler mein task properties check karo
- "Run whether user is logged on or not" check karo
- "Run with highest privileges" check karo

**Problem: Messages send nahi ho rahe**
- Solution: `cron/test_cron.php` se check karo ki messages ready hain ya nahi
- Auto messages admin panel mein check karo ki active hain ya nahi
- Groups registered hain ya nahi check karo

**Problem: Log file check karna hai**
- Location: `cron/auto_messages.log`
- Ye file automatically create hogi jab messages send honge

### Important Notes

1. **Cron job har 1 minute pe run hoga** - ye normal hai aur zaroori hai
2. **Interval messages** - agar interval 1 minute set hai, to har minute pe message jayega
3. **Daily/Weekly messages** - sirf specified time pe jayenge
4. **Active messages** - sirf active messages hi send honge
5. **Groups** - selected groups ko messages jayenge, ya sab groups ko (agar koi select nahi kiya)

### Files

- `cron/send_auto_messages.php` - Main cron job script (har minute pe run hota hai)
- `cron/setup_windows_task.ps1` - Windows automatic setup script
- `cron/setup_windows_task.bat` - Windows batch file (double-click se run)
- `cron/test_cron.php` - Test script (browser se check karne ke liye)
- `cron/auto_messages.log` - Log file (messages send hone ka record)

### Support

Agar koi problem aaye to:
1. Log file check karo: `cron/auto_messages.log`
2. Test script run karo: `cron/test_cron.php`
3. Task Scheduler mein task history check karo
4. Admin panel mein auto messages check karo

**Happy Broadcasting! 🚀**
