# Windows Task Scheduler Setup Script
# Ye script Windows Task Scheduler mein cron job setup karega
# Har 1 minute pe automatically messages groups mein bhejega

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "Telegram Bot Cron Job Setup (Windows)" -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# Get project path (script is in cron folder, so go one level up)
$projectPath = Split-Path -Parent $PSScriptRoot
$cronScript = Join-Path $PSScriptRoot "send_auto_messages.php"
$phpPath = ""

# Check if PHP is installed
Write-Host "PHP check kar raha hoon..." -ForegroundColor Yellow
$phpPath = (Get-Command php -ErrorAction SilentlyContinue).Source

if (-not $phpPath) {
    Write-Host "❌ PHP install nahi hai ya PATH mein nahi hai!" -ForegroundColor Red
    Write-Host ""
    Write-Host "Kripya PHP install karein:" -ForegroundColor Yellow
    Write-Host "1. https://windows.php.net/download/ se PHP download karein" -ForegroundColor White
    Write-Host "2. PHP ko install karein aur PATH mein add karein" -ForegroundColor White
    Write-Host "3. Ya manually PHP path specify karein:" -ForegroundColor White
    $customPhpPath = Read-Host "PHP ka full path (e.g., C:\php\php.exe)"
    if (Test-Path $customPhpPath) {
        $phpPath = $customPhpPath
    } else {
        Write-Host "❌ Invalid PHP path!" -ForegroundColor Red
        exit 1
    }
}

Write-Host "✅ PHP mil gaya: $phpPath" -ForegroundColor Green
Write-Host ""

# Verify cron script exists
if (-not (Test-Path $cronScript)) {
    Write-Host "❌ Cron script nahi mila: $cronScript" -ForegroundColor Red
    exit 1
}

Write-Host "✅ Cron script mil gaya: $cronScript" -ForegroundColor Green
Write-Host ""

# Task name
$taskName = "TelegramBotAutoMessages"

# Check if task already exists
$existingTask = Get-ScheduledTask -TaskName $taskName -ErrorAction SilentlyContinue

if ($existingTask) {
    Write-Host "⚠️  Task already exist karta hai: $taskName" -ForegroundColor Yellow
    $response = Read-Host "Kya aap existing task ko delete karke naya banaye? (y/n)"
    if ($response -eq "y" -or $response -eq "Y") {
        Unregister-ScheduledTask -TaskName $taskName -Confirm:$false
        Write-Host "✅ Old task delete ho gaya" -ForegroundColor Green
    } else {
        Write-Host "❌ Setup cancel ho gaya" -ForegroundColor Red
        exit 0
    }
}

# Create action (run PHP script)
$action = New-ScheduledTaskAction -Execute $phpPath -Argument "`"$cronScript`"" -WorkingDirectory $projectPath

# Create trigger (every minute)
$trigger = New-ScheduledTaskTrigger -Once -At (Get-Date) -RepetitionInterval (New-TimeSpan -Minutes 1) -RepetitionDuration (New-TimeSpan -Days 365)

# Create settings
$settings = New-ScheduledTaskSettingsSet -AllowStartIfOnBatteries -DontStopIfGoingOnBatteries -StartWhenAvailable -RunOnlyIfNetworkAvailable:$false

# Create principal (run as current user)
$principal = New-ScheduledTaskPrincipal -UserId "$env:USERDOMAIN\$env:USERNAME" -LogonType Interactive -RunLevel Highest

# Register the task
try {
    Register-ScheduledTask -TaskName $taskName -Action $action -Trigger $trigger -Settings $settings -Principal $principal -Description "Telegram Bot Auto Messages - Har 1 minute pe messages groups mein bhejta hai" | Out-Null
    Write-Host "✅ Task successfully create ho gaya!" -ForegroundColor Green
    Write-Host ""
    Write-Host "Task Details:" -ForegroundColor Cyan
    Write-Host "  Name: $taskName" -ForegroundColor White
    Write-Host "  Frequency: Har 1 minute" -ForegroundColor White
    Write-Host "  Script: $cronScript" -ForegroundColor White
    Write-Host ""
    Write-Host "Task ko check karne ke liye:" -ForegroundColor Yellow
    Write-Host "  Task Scheduler kholo (taskschd.msc)" -ForegroundColor White
    Write-Host "  Ya PowerShell mein: Get-ScheduledTask -TaskName '$taskName'" -ForegroundColor White
    Write-Host ""
    Write-Host "Task ko manually run karne ke liye:" -ForegroundColor Yellow
    Write-Host "  Start-ScheduledTask -TaskName '$taskName'" -ForegroundColor White
    Write-Host ""
    Write-Host "Task ko delete karne ke liye:" -ForegroundColor Yellow
    Write-Host "  Unregister-ScheduledTask -TaskName '$taskName' -Confirm:`$false" -ForegroundColor White
    Write-Host ""
} catch {
    Write-Host "❌ Error: $($_.Exception.Message)" -ForegroundColor Red
    Write-Host ""
    Write-Host "Kripya PowerShell ko Administrator mode mein run karein!" -ForegroundColor Yellow
    exit 1
}

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "Setup Complete! 🎉" -ForegroundColor Green
Write-Host "========================================" -ForegroundColor Cyan
