<?php
/**
 * Cron Job Test Script
 * Ye script manually run karke cron job ko test kar sakte hain
 * Browser ya command line se run karein
 */

// Include configuration
require_once __DIR__ . '/../config/config.php';

// Set execution time limit
set_time_limit(60);

echo "<!DOCTYPE html>
<html lang='en'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Cron Job Test - Telegram Bot</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #333;
            border-bottom: 3px solid #667eea;
            padding-bottom: 10px;
        }
        .info {
            background: #e7f3ff;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            border-left: 4px solid #0066cc;
        }
        .success {
            background: #d4edda;
            padding: 15px;
            border-radius: 5px;
            margin: 10px 0;
            border-left: 4px solid #28a745;
            color: #155724;
        }
        .error {
            background: #f8d7da;
            padding: 15px;
            border-radius: 5px;
            margin: 10px 0;
            border-left: 4px solid #dc3545;
            color: #721c24;
        }
        .warning {
            background: #fff3cd;
            padding: 15px;
            border-radius: 5px;
            margin: 10px 0;
            border-left: 4px solid #ffc107;
            color: #856404;
        }
        pre {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            font-size: 13px;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
        .btn:hover {
            background: #5568d3;
        }
    </style>
</head>
<body>
    <div class='container'>
        <h1>🧪 Cron Job Test</h1>
        <div class='info'>
            <strong>ℹ️ Current Time:</strong> " . date('Y-m-d H:i:s') . "<br>
            <strong>📁 Script Path:</strong> " . __FILE__ . "<br>
            <strong>🌐 Timezone:</strong> " . date_default_timezone_get() . "
        </div>
";

try {
    // Initialize database
    $db = Database::getInstance();
    $db->initDatabase();
    
    echo "<div class='success'>✅ Database connection successful!</div>";
    
    // Get all groups
    $allGroups = $db->getAllGroups();
    echo "<div class='info'><strong>📊 Total Groups:</strong> " . count($allGroups) . "</div>";
    
    if (empty($allGroups)) {
        echo "<div class='warning'>⚠️ No groups registered. Add bot to groups first!</div>";
    } else {
        echo "<div class='info'><strong>Groups List:</strong><br>";
        foreach ($allGroups as $group) {
            echo "  • " . htmlspecialchars($group['group_id']) . "<br>";
        }
        echo "</div>";
    }
    
    // Get messages to send
    $messagesToSend = $db->getAutoMessagesToSend();
    
    echo "<div class='info'><strong>📨 Messages to Send:</strong> " . count($messagesToSend) . "</div>";
    
    if (empty($messagesToSend)) {
        echo "<div class='warning'>⚠️ No messages scheduled to send at this time.</div>";
        echo "<div class='info'>";
        echo "<strong>💡 Tips:</strong><br>";
        echo "• Check if you have active auto messages in admin panel<br>";
        echo "• For interval messages, make sure current time is within start_time and end_time<br>";
        echo "• For daily/weekly messages, make sure current time matches send_time<br>";
        echo "• Check last_sent timestamp - messages won't send again until interval passes<br>";
        echo "</div>";
    } else {
        echo "<div class='success'>✅ Found " . count($messagesToSend) . " message(s) ready to send!</div>";
        
        foreach ($messagesToSend as $msg) {
            echo "<div class='info'>";
            echo "<strong>Message ID:</strong> " . $msg['id'] . "<br>";
            echo "<strong>Frequency:</strong> " . $msg['frequency'] . "<br>";
            echo "<strong>Message:</strong> " . htmlspecialchars(substr($msg['message'], 0, 100)) . "...<br>";
            if ($msg['frequency'] === 'interval') {
                echo "<strong>Time Range:</strong> " . $msg['start_time'] . " - " . $msg['end_time'] . "<br>";
                echo "<strong>Interval:</strong> " . $msg['interval_minutes'] . " minutes<br>";
            } else {
                echo "<strong>Send Time:</strong> " . ($msg['send_time'] ?: 'N/A') . "<br>";
            }
            echo "</div>";
        }
        
        // Ask if user wants to actually send
        if (isset($_GET['send']) && $_GET['send'] === 'yes') {
            echo "<div class='info'><strong>🚀 Sending messages...</strong></div>";
            
            // Include the actual cron logic
            require_once __DIR__ . '/send_auto_messages.php';
            
        } else {
            echo "<div class='warning'>";
            echo "⚠️ <strong>Test Mode:</strong> Messages abhi send nahi huye hain.<br>";
            echo "Actual messages send karne ke liye: <a href='?send=yes' class='btn'>Send Messages Now</a>";
            echo "</div>";
        }
    }
    
    // Show all auto messages
    $allAutoMessages = $db->getAllAutoMessages();
    echo "<div class='info' style='margin-top: 30px;'>";
    echo "<strong>📋 All Auto Messages (" . count($allAutoMessages) . "):</strong><br><br>";
    
    if (empty($allAutoMessages)) {
        echo "No auto messages configured yet.<br>";
    } else {
        echo "<table style='width:100%; border-collapse: collapse;'>";
        echo "<tr style='background: #f8f9fa;'>";
        echo "<th style='padding: 10px; text-align: left; border: 1px solid #ddd;'>ID</th>";
        echo "<th style='padding: 10px; text-align: left; border: 1px solid #ddd;'>Frequency</th>";
        echo "<th style='padding: 10px; text-align: left; border: 1px solid #ddd;'>Time</th>";
        echo "<th style='padding: 10px; text-align: left; border: 1px solid #ddd;'>Active</th>";
        echo "<th style='padding: 10px; text-align: left; border: 1px solid #ddd;'>Last Sent</th>";
        echo "</tr>";
        
        foreach ($allAutoMessages as $msg) {
            $statusClass = $msg['is_active'] ? 'success' : 'error';
            $statusText = $msg['is_active'] ? '✅ Active' : '❌ Inactive';
            
            echo "<tr>";
            echo "<td style='padding: 10px; border: 1px solid #ddd;'>" . $msg['id'] . "</td>";
            echo "<td style='padding: 10px; border: 1px solid #ddd;'>" . ucfirst($msg['frequency']) . "</td>";
            echo "<td style='padding: 10px; border: 1px solid #ddd;'>";
            if ($msg['frequency'] === 'interval') {
                echo $msg['start_time'] . " - " . $msg['end_time'] . " (every " . $msg['interval_minutes'] . " min)";
            } else {
                echo $msg['send_time'] ?: 'N/A';
            }
            echo "</td>";
            echo "<td style='padding: 10px; border: 1px solid #ddd;'><span class='$statusClass'>$statusText</span></td>";
            echo "<td style='padding: 10px; border: 1px solid #ddd;'>" . ($msg['last_sent'] ?: 'Never') . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    }
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div class='error'>";
    echo "❌ <strong>Error:</strong> " . htmlspecialchars($e->getMessage());
    echo "</div>";
}

echo "
        <div style='margin-top: 30px; padding-top: 20px; border-top: 2px solid #eee;'>
            <strong>📝 Notes:</strong>
            <ul>
                <li>Ye test script hai - actual cron job <code>send_auto_messages.php</code> hai</li>
                <li>Cron job har 1 minute pe automatically run hoga</li>
                <li>Windows pe Task Scheduler setup karein: <code>setup_windows_task.ps1</code></li>
                <li>Linux/Unix pe crontab use karein: <code>* * * * * php /path/to/cron/send_auto_messages.php</code></li>
            </ul>
        </div>
        
        <a href='test_cron.php' class='btn'>🔄 Refresh</a>
        <a href='../admin/dashboard.php' class='btn' style='background: #6c757d;'>📊 Admin Dashboard</a>
    </div>
</body>
</html>";
