USE tashanw3_selimxpro;

CREATE TABLE IF NOT EXISTS telegram_groups (
    id INT AUTO_INCREMENT PRIMARY KEY,
    group_id VARCHAR(50) UNIQUE NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS auto_messages (
    id INT AUTO_INCREMENT PRIMARY KEY,
    message TEXT NOT NULL,
    send_time TIME NULL,
    send_date DATE NULL,
    start_time TIME NULL,
    end_time TIME NULL,
    start_date DATE NULL,
    end_date DATE NULL,
    interval_minutes INT NULL DEFAULT 1,
    frequency ENUM('daily', 'weekly', 'interval', 'once') NOT NULL DEFAULT 'daily',
    group_ids TEXT NULL,
    is_active TINYINT(1) NOT NULL DEFAULT 1,
    last_sent DATETIME NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS color_predictions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    result_type ENUM('big', 'small', 'number') NOT NULL,
    result_value VARCHAR(10) NOT NULL,
    period_number INT NOT NULL,
    is_sent TINYINT(1) NOT NULL DEFAULT 0,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    sent_at DATETIME NULL,
    INDEX idx_period (period_number),
    INDEX idx_sent (is_sent),
    INDEX idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;